<?php
// Define the start date of the week (assuming the current week)
$startDate = date('Y-m-d', strtotime('monday this week'));

// Define the end date of the week
$endDate = date('Y-m-d', strtotime('sunday this week'));

// Generate an array of days in the week
$daysInWeek = [];
$currentDate = $startDate;
while ($currentDate <= $endDate) {
    $daysInWeek[] = $currentDate;
    $currentDate = date('Y-m-d', strtotime('+1 day', strtotime($currentDate)));
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Weekly Calendar</title>
    <style>
        .calendar {
            width: 100%;
            border-collapse: collapse;
        }
        .calendar th, .calendar td {
            border: 1px solid #ccc;
            padding: 5px;
            text-align: center;
        }
        .calendar th {
            background-color: #f2f2f2;
        }
    </style>
</head>
<body>
    <h2>Weekly Calendar</h2>
    <table class="calendar">
        <thead>
            <tr>
                <?php foreach ($daysInWeek as $day): ?>
                    <th><?php echo date('D, d M Y', strtotime($day)); ?></th>
                <?php endforeach; ?>
            </tr>
        </thead>
        <tbody>
            <tr>
                <?php foreach ($daysInWeek as $day): ?>
                    <td>
                        <?php
                        // Replace this with your logic to fetch and display data for each day
                        echo "Sample Data for " . date('Y-m-d', strtotime($day));
                        ?>
                    </td>
                <?php endforeach; ?>
            </tr>
        </tbody>
    </table>
</body>
</html>
